/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.usage.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.usage.AnalyticsEvent;
import com.aptana.usage.IAnalyticsEventHandler;
import com.aptana.usage.IAnalyticsLogger;
import com.aptana.usage.IAnalyticsUser;
import com.aptana.usage.IAnalyticsUserManager;
import com.aptana.usage.Messages;
import com.aptana.usage.UsagePlugin;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class DefaultAnalyticsEventHandler
implements IAnalyticsEventHandler {
    static final String DEFAULT_URL = "https://api.appcelerator.com/p/v1/app-track";
    static final int DEFAULT_TIMEOUT = 5000;
    private final String url;
    private final int timeout;
    protected int responseCode = 0;
    protected Object lock = new Object();

    public DefaultAnalyticsEventHandler() {
        this(5000, EclipseUtil.getSystemProperty((String)"studio.analyticsURL"));
    }

    DefaultAnalyticsEventHandler(int timeout, String url) {
        this.timeout = timeout;
        this.url = url;
    }

    public void sendEvent(final AnalyticsEvent event) {
        Job job = new Job("Sending Analytics Ping ..."){

            protected IStatus run(IProgressMonitor monitor) {
                return DefaultAnalyticsEventHandler.this.sendEventSync(event);
            }

            public boolean belongsTo(Object family) {
                return family.equals(IAnalyticsEventHandler.class);
            }
        };
        job.setSystem(true);
        job.setPriority(40);
        job.schedule();
    }

    public String getAnalyticsURL() {
        if (StringUtil.isEmpty((String)this.url)) {
            return DEFAULT_URL;
        }
        return this.url;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getLastResponseCode() {
        return this.responseCode;
    }

    protected int sendPing(AnalyticsEvent event, IAnalyticsUser user) {
        HttpURLConnection connection = null;
        FilterOutputStream output = null;
        try {
            int code;
            URL url = new URL(this.getAnalyticsURL());
            connection = this.createConnection(url);
            if (user != null) {
                connection.setRequestProperty("Cookie", String.valueOf(user.getCookie()) + "; uid=" + user.getGUID());
            }
            connection.setRequestProperty("User-Agent", AnalyticsEvent.getUserAgent());
            connection.setDoOutput(true);
            connection.setReadTimeout(this.getTimeout());
            connection.setConnectTimeout(this.getTimeout());
            connection.setRequestMethod("POST");
            String data = event.getEventString();
            output = this.createOutputStream(connection, data);
            if (IdeLog.isTraceEnabled((Plugin)UsagePlugin.getDefault(), (String)"com.aptana.usage/debug/usage")) {
                IdeLog.logTrace((Plugin)UsagePlugin.getDefault(), (String)MessageFormat.format("Sending usage: {0}, {1}", url, data));
            }
            if ((code = connection.getResponseCode()) == 401 || code == 403) {
                UsagePlugin.logError(MessageFormat.format(Messages.StudioAnalytics_connection_unauthorized, Integer.toString(code)));
            } else if (code < 200 || code > 205) {
                UsagePlugin.logError(MessageFormat.format(Messages.StudioAnalytics_connection_failed, Integer.toString(code)));
            }
            int n = code;
            return n;
        }
        catch (Exception e) {
            UsagePlugin.logError(e);
            return 503;
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    protected DataOutputStream createOutputStream(HttpURLConnection connection, String data) throws IOException {
        DataOutputStream dos = new DataOutputStream(connection.getOutputStream());
        dos.writeBytes(data);
        dos.flush();
        return dos;
    }

    protected HttpURLConnection createConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    protected IAnalyticsLogger getAnalyticsLogger() {
        UsagePlugin plugin = UsagePlugin.getDefault();
        if (plugin == null) {
            return null;
        }
        return plugin.getAnalyticsLogger();
    }

    protected IAnalyticsUserManager getUserManager() {
        return AnalyticsEvent.getUserManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus sendEventSync(AnalyticsEvent event) {
        IAnalyticsUserManager userManager = this.getUserManager();
        if (userManager == null) {
            IAnalyticsLogger logger;
            this.responseCode = this.sendPing(event, null);
            if (!DefaultAnalyticsEventHandler.isValidResponse(this.responseCode) && (logger = this.getAnalyticsLogger()) != null) {
                logger.logEvent(event);
            }
            return Status.OK_STATUS;
        }
        IAnalyticsUser user = userManager.getUser();
        if (user == null || !user.isOnline() || !DefaultAnalyticsEventHandler.isValidResponse(this.responseCode = this.sendPing(event, user))) {
            IAnalyticsLogger logger = this.getAnalyticsLogger();
            if (logger != null) {
                logger.logEvent(event);
            } else {
                IdeLog.logWarning((Plugin)UsagePlugin.getDefault(), (String)"No Analytics logger around to log event. Event will be dropped!");
            }
        } else {
            IAnalyticsLogger logger = this.getAnalyticsLogger();
            if (logger != null) {
                Object object = this.lock;
                synchronized (object) {
                    List<AnalyticsEvent> events = logger.getEvents();
                    if (events.isEmpty()) {
                        logger.clearEvents();
                    }
                    Collections.sort(events, new AnalyticsEventComparator());
                    for (AnalyticsEvent aEvent : events) {
                        this.responseCode = this.sendPing(aEvent, user);
                        if (!DefaultAnalyticsEventHandler.isValidResponse(this.responseCode)) {
                            return Status.OK_STATUS;
                        }
                        logger.clearEvent(aEvent);
                    }
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected static boolean isValidResponse(int code) {
        return code < 500 || code >= 510;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AnalyticsEventComparator
    implements Comparator<AnalyticsEvent> {
        private static String PROJECT_CREATE = "project.create";
        private static String PROJECT_DELETE = "project.delete";

        protected AnalyticsEventComparator() {
        }

        @Override
        public int compare(AnalyticsEvent o1, AnalyticsEvent o2) {
            return this.calculatePriority(o1) - this.calculatePriority(o2);
        }

        private int calculatePriority(AnalyticsEvent event) {
            String eventName = event.getEventName();
            if (eventName.startsWith(PROJECT_CREATE)) {
                return -1;
            }
            if (eventName.startsWith(PROJECT_DELETE)) {
                return 1;
            }
            return 0;
        }
    }
}

